function getPageScroll(){

	var yScroll;

	if (self.pageYOffset) {
		yScroll = self.pageYOffset;
	} else if (document.documentElement && document.documentElement.scrollTop){	 // Explorer 6 Strict
		yScroll = document.documentElement.scrollTop;
	} else if (document.body) {// all other Explorers
		yScroll = document.body.scrollTop;
	}

	arrayPageScroll = new Array('',yScroll) 
	return arrayPageScroll;
}



function getPageSize(){
	
	var xScroll, yScroll;
	
	if (window.innerHeight && window.scrollMaxY) {	
		xScroll = document.body.scrollWidth;
		yScroll = window.innerHeight + window.scrollMaxY;
	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}
	
	var windowWidth, windowHeight;
	if (self.innerHeight) {	// all except Explorer
		windowWidth = self.innerWidth;
		windowHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}	
	
	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight){
		pageHeight = windowHeight;
	} else { 
		pageHeight = yScroll;
	}

	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth){	
		pageWidth = windowWidth;
	} else {
		pageWidth = xScroll;
	}

	arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight) 
	return arrayPageSize;
}
	


function popupPM(pmLink)
{
	// prep objects
	var objOverlay = document.getElementById('overlay');
	var objLightbox = document.getElementById('lightbox');
	
	var arrayPageSize = getPageSize();
	var arrayPageScroll = getPageScroll();

	if (useLightbox == '1') {
		objOverlay.style.height = (arrayPageSize[1] + 'px');
		objOverlay.style.display = 'block';
	}

	// center lightbox and make sure that the top and left values are not negative
	// and the image placed outside the viewport
	var lightboxTop = arrayPageScroll[1] + ((arrayPageSize[3] - 35 - pmHeight) / 2);
	var lightboxLeft = ((arrayPageSize[0] - 20 - pmWidth) / 2);
	
	objLightbox.style.top = (lightboxTop < 0) ? "0px" : lightboxTop + "px";
	objLightbox.style.left = (lightboxLeft < 0) ? "0px" : lightboxLeft + "px";
	
	// Please DO NOT remove the link giving me credit for this modification... I did put a lot of time into it. Thank you! -Rob
	objLightbox.innerHTML = '<table cellpadding="6" cellspacing="0" border="0" width="'+pmWidth+'"><tr><td class="tcat" align="right"><span style="float: left">أرسل رسالة خاصة</span><a onclick="hidePopupPM();"><img src="images/misc/cross.png"></a></td></tr><tr><td class="alt2"><iframe name="popuppmframe" id="popuppmframe" src="'+pmLink+'&amp;popuppm=newpm" frameborder="0" width="'+pmWidth+'" height="'+pmHeight+'" scrolling="auto"></iframe></td></tr></table>';
	objLightbox.style.display = 'block';

	// After image is loaded, update the overlay height as the new image might have
	// increased the overall page height.
	arrayPageSize = getPageSize();
	objOverlay.style.height = (arrayPageSize[1] + 'px');

	return false;
}



function hidePopupPM()
{
	// get objects
	objOverlay = document.getElementById('overlay');
	objLightbox = document.getElementById('lightbox');

	// hide lightbox and overlay
	objOverlay.style.display = 'none';
	objLightbox.style.display = 'none';
}



function initPopupPM() {
	if (!document.getElementsByTagName){ return; }
	var anchors = document.getElementsByTagName("a");

	// loop through all anchor tags
	for (var i=0; i<anchors.length; i++){
		var anchor = anchors[i];

		if (anchor.getAttribute("href") && (anchor.getAttribute("href").indexOf('newpm') !=-1)){
			eval('anchor.onclick = function () { popupPM("' + anchor.getAttribute("href") + '"); return false; }');
		}
	}
}



function addLoadEvent(func)
{	
	var oldonload = window.onload;
	if (typeof window.onload != 'function'){
    	window.onload = func;
	} else {
		window.onload = function(){
		oldonload();
		func();
		}
	}

}



addLoadEvent(initPopupPM);